/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.sound;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.openal.AL;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.util.ResourceLoader;

public class SoundSystem {
    private final Map<String, Audio> sounds = new HashMap<String, Audio>();
    private final Map<String, Boolean> isMusicMap = new HashMap<String, Boolean>();
    private final Map<String, Audio> activeSounds = new HashMap<String, Audio>();
    private Audio currentMusic;
    private boolean audioFunctional = false;

    public SoundSystem() {
        this.init();
    }

    private void init() {
        try {
            SoundStore.get().init();
            this.audioFunctional = SoundStore.get().soundWorks();
            if (this.audioFunctional) {
                System.out.println("Slick2D sound system initialized successfully");
            } else {
                System.err.println("Slick2D sound system not functional");
            }
        }
        catch (Exception e2) {
            System.err.println("Failed to initialize Slick2D audio: " + e2.getMessage());
            e2.printStackTrace();
            this.audioFunctional = false;
        }
    }

    public boolean loadSound(String soundId, String filePath) {
        if (!this.audioFunctional) {
            System.err.println("Cannot load sound: Slick2D audio system not functional");
            return false;
        }
        String extension = this.getFileExtension(filePath).toLowerCase();
        if (extension.equals("wav") || extension.equals("ogg")) {
            Audio audio = this.loadSlickSound(soundId, filePath, extension);
            if (audio == null) {
                return false;
            }
            this.sounds.put(soundId, audio);
            this.isMusicMap.put(soundId, extension.equals("ogg"));
            System.out.println(String.valueOf(filePath) + " -> " + soundId);
            return true;
        }
        System.err.println("Unsupported file format: " + extension);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Audio loadSlickSound(String soundId, String filePath, String extension) {
        InputStream inputStream;
        String format;
        block4: {
            try {
                format = extension.toUpperCase();
                if (extension.equals("wav")) {
                    return AudioLoader.getAudio(format, ResourceLoader.getResourceAsStream(filePath));
                }
                inputStream = ResourceLoader.getResourceAsStream(filePath);
                if (inputStream != null) break block4;
                System.err.println("Resource not found: " + filePath);
                return null;
            }
            catch (IOException e2) {
                System.err.println("Error loading " + extension.toUpperCase() + " file: " + filePath + " - " + e2.getMessage());
                e2.printStackTrace();
                return null;
            }
        }
        return AudioLoader.getAudio(format, inputStream);
    }

    private String getFileExtension(String filePath) {
        String fileName = new File(filePath).getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    public void playSFX(String soundId) {
        this.playSFX(soundId, 1.0f, 1.0f);
    }

    public void playSFX(String soundId, float pitch) {
        this.playSFX(soundId, pitch, 1.0f);
    }

    public void playSFX(String soundId, float pitch, float volume) {
        if (!this.audioFunctional) {
            System.err.println("Cannot play sound: " + soundId + " - Slick2D audio system not functional");
            return;
        }
        Audio audio = this.sounds.get(soundId);
        if (audio == null) {
            System.err.println("Sound not found: " + soundId);
            return;
        }
        Boolean isMusic = this.isMusicMap.get(soundId);
        if (isMusic != null && isMusic.booleanValue()) {
            System.err.println("Use playMusic for music files: " + soundId);
            return;
        }
        if (pitch < 0.5f || pitch > 2.0f) {
            System.err.println("Pitch value out of range (0.5-2.0): " + pitch);
            return;
        }
        if (volume < 0.0f || volume > 1.0f) {
            System.err.println("Volume value out of range (0.0-1.0): " + volume);
            return;
        }
        try {
            audio.playAsSoundEffect(pitch, volume, false);
            this.activeSounds.put(String.valueOf(soundId) + System.nanoTime(), audio);
        }
        catch (Exception e2) {
            System.err.println("Error playing sound: " + soundId + " - " + e2.getMessage());
        }
    }

    public void playMusic(String soundId, float pitch, float volume, boolean loop) {
        if (!this.audioFunctional) {
            System.err.println("Cannot play music: " + soundId + " - Slick2D audio system not functional");
            return;
        }
        Audio audio = this.sounds.get(soundId);
        if (audio == null) {
            System.err.println("Music not found: " + soundId);
            return;
        }
        if (pitch < 0.5f || pitch > 2.0f) {
            System.err.println("Pitch value out of range (0.5-2.0): " + pitch);
            return;
        }
        if (volume < 0.0f || volume > 1.0f) {
            System.err.println("Volume value out of range (0.0-1.0): " + volume);
            return;
        }
        try {
            if (this.currentMusic != null && this.currentMusic.isPlaying()) {
                this.currentMusic.stop();
                System.out.println("Stopped previous music");
            }
            audio.playAsMusic(pitch, volume, loop);
            Thread.sleep(100L);
            if (!audio.isPlaying()) {
                System.err.println("Music " + soundId + " failed to start playing.");
            }
            this.currentMusic = audio;
            this.activeSounds.put(String.valueOf(soundId) + System.nanoTime(), audio);
        }
        catch (Exception e2) {
            System.err.println("Error playing music: " + soundId + " - " + e2.getMessage());
        }
    }

    public void destroy() {
        if (this.currentMusic != null && this.currentMusic.isPlaying()) {
            try {
                this.currentMusic.stop();
                System.out.println("Stopped current music");
            }
            catch (Exception e2) {
                System.err.println("Error stopping current music: " + e2.getMessage());
            }
            this.currentMusic = null;
        }
        for (Audio audio : this.activeSounds.values()) {
            try {
                if (!audio.isPlaying()) continue;
                audio.stop();
            }
            catch (Exception e3) {
                System.err.println("Error stopping sound: " + e3.getMessage());
            }
        }
        this.activeSounds.clear();
        this.sounds.clear();
        this.isMusicMap.clear();
        try {
            SoundStore.get().clear();
            System.out.println("SoundStore cleared");
        }
        catch (Exception e4) {
            System.err.println("Error cleaning up SoundStore: " + e4.getMessage());
        }
        try {
            if (AL.isCreated()) {
                AL.destroy();
                System.out.println("OpenAL context destroyed");
            }
        }
        catch (Exception e5) {
            System.err.println("Error destroying OpenAL context: " + e5.getMessage());
        }
    }

    public boolean isAudioFunctional() {
        return this.audioFunctional;
    }
}

